﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace DocumentProcessing
{
    class Program
    {
        // Listing 5-19. Rozbudowana funkcja do rejestrowania komunikatów w dzienniku
        static void Main(string[] args)
        {
            Document doc1 = new Document
            {
                Author = "Jan Kowalski",
                DocumentDate = new DateTime(2000, 01, 01),
                Text = "Czy przybyłem za wcześnie?"
            };
            Document doc2 = new Document
            {
                Author = "Wiesław Zatorski",
                DocumentDate = new DateTime(2001, 01, 01),
                Text = "Wierzcie mi! Nadchodzi nowe milenium."
            };
            Document doc3 = new Document
            {
                Author = "Jan Kowalski",
                DocumentDate = new DateTime(2002, 01, 01),
                Text = "Inny rok, inny dokument."
            };
            string documentBeingProcessed = null;
            DocumentProcessor processor = Configure();
            processor.LogTextProvider = (doc => documentBeingProcessed);
            documentBeingProcessed = "(Dokument 1.)";
            processor.Process(doc1);
            Console.WriteLine();
            documentBeingProcessed = "(Dokument 2.)";
            processor.Process(doc2);
            Console.WriteLine();
            documentBeingProcessed = "(Dokument 3.)";
            processor.Process(doc3);
            Console.ReadKey();
        }

        static DocumentProcessor Configure()
        {
            DocumentProcessor rc = new DocumentProcessor();
            rc.AddProcess(
                DocumentProcesses.TranslateIntoFrench,
                doc => !doc.Text.Contains("?"));
            rc.AddProcess(DocumentProcesses.Spellcheck);
            rc.AddProcess(DocumentProcesses.Repaginate);

            TrademarkFilter trademarkFilter = new TrademarkFilter();
            trademarkFilter.Trademarks.Add("Wiesław");
            trademarkFilter.Trademarks.Add("Zatorski");
            trademarkFilter.Trademarks.Add("milenium");

            rc.AddProcess(trademarkFilter.HighlightTrademarks);

            return rc;
        }
    }
}
